# Copyright (C) 2021-2024 MicroSys Electronics GmbH
# Authors: Kay Potthoff <kay.potthoff@microsys.de>, Florian Aigner <florian.aigner@microsys.de

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

FWDIR = "${nonarch_base_libdir}/firmware"

COMPATIBLE_MACHINE:append = "|mpxs32g"

S32_VERSION:s32g2 = "s32g2"
S32_VERSION:s32g3 = "s32g3"
FWSRC = "${S}/../NXPFWGITREPO/llce/${S32_VERSION}"
FILESEXTRAPATHS:prepend := "${FWSRC}:"

LIC_FILES_CHKSUM += "${@bb.utils.contains('DISTRO_FEATURES', \
    'llce-fw-load', \
    'file://${FWSRC}/license.rtf;md5=2404c94395614cb73b0dc475bb179978', \
    '', d)}"


SRC_URI += '${@bb.utils.contains("DISTRO_FEATURES", "llce-fw-load", d.getVar('URI_NXPFWGITREPO'), "", d)}'

module_conf_llce-core = ""

# Place ${PN}-rtw88 in the list of packages
# Important note: the package needs to be prepended with '=+',
# because the main package ${PN} *has to be* the last package
# in the list.
# Background: finally, the recipe linux-firmware_*.bb will grab
# *all* files in ${FWDIR}:
# > FILES:${PN} += "${nonarch_base_libdir}/firmware/*"
# If a package is listed after ${PN} then there are no more files
# left.
PACKAGES =+ "${@bb.utils.contains('DISTRO_FEATURES', \
    'wifi', \
    ' ${PN}-rtw88 ', \
    '', d)}"

PACKAGES =+ "${PN}-llce"

do_populate_lic:prepend() {
    import os
    import shutil

    if "llce-fw-load" in d.getVar('DISTRO_FEATURES'):
        shutil.copy2(os.path.join(d.getVar("FWSRC"), "license.rtf"),
                    os.path.join(d.getVar("S"), "license.rtf"))
}

do_install:prepend() {
    if ${@bb.utils.contains('DISTRO_FEATURES', 'llce-fw-load', 'true', 'false', d)}; then
       mkdir -p ${D}${base_libdir}/firmware/
       install -m 0644 ${FWSRC}/dte.bin ${D}/${base_libdir}/firmware/dte.bin
       install -m 0644 ${FWSRC}/frpe.bin ${D}/${base_libdir}/firmware/frpe.bin
       install -m 0644 ${FWSRC}/ppe_tx.bin ${D}/${base_libdir}/firmware/ppe_tx.bin
       install -m 0644 ${FWSRC}/ppe_rx.bin ${D}/${base_libdir}/firmware/ppe_rx.bin
    fi
}

python do_fetch:prepend() {
    # Due to lack of yocto kirkstone features, its hard to do this check in a better way that doesn't flag false negatives
    if "llce-fw-load" in d.getVar('DISTRO_FEATURES') and "microsys.local" in d.getVar('URI_NXPFWGITREPO'):
         bb.warn("You will try to fetch NXP Firmware from internal microsys servers.")
         bb.warn("In case you see a fetch error afterwards, please check the \"software enablement guide\" as part of release notes.")
}

FILES:${PN}-rtw88 = "${FWDIR}/rtw88/rtw8822*.bin"
FILES:${PN}-llce = "${base_libdir}/firmware/dte.bin \
                    ${base_libdir}/firmware/frpe.bin \
                    ${base_libdir}/firmware/ppe_tx.bin \
                    ${base_libdir}/firmware/ppe_rx.bin"
